<?
    // Define subscriber file
    $subsFile = 'subscriber.dat';
    
    // Define admin username and password
    $adminUsername = "steve";
    $adminPassword = "nottelling";
    
    // If supplied username/password do not match above
    if ($inUsername != $adminUsername || $inPassword != $adminPassword) {
        // Output error information and quit
        print "Invalid username or password";
        exit;
    }

    // Decide on what action we need to take
    switch($action) {
        // Fetch list of subscribers
        case "List Subscribers":
            fetchList();
            break;
        
        // Send email to subscribers
        case "Send Email":
            sendEmail($mailSubject, $mailBody);
            break;
            
        default:
            print "Unknown action: $action";
            exit;
    }
    

function fetchList() {
    // Register global variables
    global $subsFile;
    
    // Attempt to open subscriber file
    $subscribers = file($subsFile);

    if (!$subscribers) {
        // Output error information and quit
        print "Couldn't open subscriber file or no subscribers listed";
        exit;
    }

    // For each subscriber line...
    foreach($subscribers as $count => $subscriber) {
        // split subscriber info into array
        $info = explode('|', $subscriber);
        
        // Assign array to meaningful variable name
        $name = $info[0];
        $email = $info[1];
        $joined = $info[2];
        
        // Create a readable joined date out of timestamp
        $joined = strftime("%D", $joined);
        
        // Output information for each subscriber
        print "<b>Subscriber $count</b><br>";
        print "Name: $name<br>\n";
        print "Email: $email<br>\n";
        print "Joined: $joined<br>\n";
        print "<br>\n";
    }
}

function sendEmail ($mailSubject, $mailBody) {
    // Register global variables
    global $subsFile;
    
    // Set up reply address for mailing list
    $mailFrom = "Mailing List <you@youremail.com";

    // Ensure that subject and body of email have
    // automatically inserted escape slashes removed
    $mailSubject = stripslashes($mailSubject);
    $mailBody = stripslashes($mailBody);
    
    // Attempt to read subscriber file
    $subscribers = file($subsFile);

    // If file open failed...
    if (!$subscribers) {
        // Output error information and quit
        print "Couldn't open subscriber file or no subscribers listed";
        exit;
    }

    // For each subscriber line...
    foreach($subscribers as $subscriber) {
        // split subscriber info into array
        $info = explode('|', $subscriber);
        
        // Assign array to meaningful variable name
        $name = $info[0];
        $email = $info[1];
        $joined = $info[2];

        // Build to address including subscriber name
        $mailTo = "$name <$email>";
        
        // Send email to
        mail($mailTo, $mailSubject, $mailBody, "From: " . $mailFrom);
    }
    
    print "Email sent to all subscribers";
}    



?>